/*
 * MazeBuilderProgress.java
 *
 * Created on April 22, 2003, 2:21 PM
 *
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

import nom.DannyBrewer.OOoUno.*;

import nom.DannyBrewer.recreation.squareMaze.*;
import nom.DannyBrewer.utils.ExceptionHandler;

/**
 *
 * @author  dbrewer
 */
public class MazeBuilderProgress extends javax.swing.JFrame implements Runnable {
    
    public MazeBuilderProgress() {
        initComponents();
    }
    
    
    
    public int cellsAcross = 35;
    public int cellsDown = 25;
    float solutionTwistFactor = 0.4f;
    float deadEndTwistFactor = 0.5f;
    boolean generateSolution = true;
    boolean solutionIsVisible = true;
    boolean solutionIsPrintable = false;
    int numPages = 1;
    String host = "localhost";
    String port = "8100";
    
    public void buildMaze() {
        show();
        Thread t = new Thread( this );
        t.start();
    }
    
    public void run() {
        lblMessage.setText( "Connecting to " + host + ":" + port + "..." );
        
        Object oOORmtServiceMgr = null;
        try {
            oOORmtServiceMgr = OOUtils.getOORemoteServiceManager( host, port );
        }
        catch ( java.lang.Exception e ) {
            ExceptionHandler.unexpectedException( e );
            //			e.printStackTrace();
            lblMessage.setText( "Unable to connect." );
            return;
        }
        
        
        lblMessage.setText( "Creating new Draw document..." );
        
        DrawDocMaze drawDocMaze = null;
        try {
            drawDocMaze = new DrawDocMaze( oOORmtServiceMgr );
        }
        catch ( java.lang.Exception e ) {
            ExceptionHandler.unexpectedException( e );
            //			e.printStackTrace();
            lblMessage.setText( "Unable to create drawing." );
            return;
        }
        
        
        drawDocMaze.setSolutionGenerated( generateSolution );
        drawDocMaze.setSolutionVisible( solutionIsVisible );
        drawDocMaze.setSolutionPrintable( solutionIsPrintable );
        
        
        lblMessage.setText( "Initializing maze..." );
        
        SquareMaze maze = new SquareMaze( cellsDown, cellsAcross );
        SquareMazeGenerator1 mazeMaker = new SquareMazeGenerator1( maze );
        
        for( int i = 0;  i < numPages;  ++i ) {
            lblMessage.setText( "Page " + (i+1) + " - Creating maze..." );
            
            maze.initializeMazeCells();
            mazeMaker.generateMaze();
            
            lblMessage.setText( "Page " + (i+1) + " - Drawing maze..." );
            
            // Draw the current maze.
            drawDocMaze.drawMaze( maze );
        }
        
        lblMessage.setText( "Maze completed." );
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        lblMessage = new javax.swing.JLabel();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        lblMessage.setText("jLabel1");
        lblMessage.setMinimumSize(new java.awt.Dimension(400, 14));
        lblMessage.setPreferredSize(new java.awt.Dimension(400, 14));
        getContentPane().add(lblMessage, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents
    
    /** Exit the Application */
	private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
            if( testMode ) System.exit(0);
	}//GEN-LAST:event_exitForm
        
        private boolean testMode = false;
        
        /**
         * @param args the command line arguments
         */
        public static void main(String args[]) {
            MazeBuilderProgress m = new MazeBuilderProgress();
            m.testMode = true;
            m.show();
        }
        
        
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblMessage;
    // End of variables declaration//GEN-END:variables
    
}
